@extends('layouts.vendedor')

@section('title', 'Solicitar Edición de Cliente')

@section('content')
<div class="page-header">
    <h1 class="page-title">Solicitar Edición: {{ $cliente->nombre_empresa }}</h1>
    <a href="{{ route('vendedor.clientes.show', $cliente->id) }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Volver
    </a>
</div>

<form action="{{ route('vendedor.clientes.solicitar-edicion.store', $cliente->id) }}" method="POST" class="form-container">
    @csrf
    
    <div class="info-box">
        <p><strong>Nota:</strong> Solo completa los campos que deseas modificar. Los campos vacíos no se cambiarán.</p>
    </div>
    
    <div class="form-group">
        <label for="nombre_empresa">Nombre de la Empresa</label>
        <input type="text" name="nombre_empresa" id="nombre_empresa" 
               class="form-control" value="{{ old('nombre_empresa', $cliente->nombre_empresa) }}" 
               placeholder="Dejar vacío para mantener: {{ $cliente->nombre_empresa }}">
    </div>
    
    <div class="form-group">
        <label for="rif">RIF</label>
        <input type="text" name="rif" id="rif" 
               class="form-control" value="{{ old('rif', $cliente->rif) }}"
               placeholder="Dejar vacío para mantener: {{ $cliente->rif }}">
    </div>
    
    <div class="form-group">
        <label for="direccion_fiscal">Dirección Fiscal</label>
        <textarea name="direccion_fiscal" id="direccion_fiscal" 
                  class="form-control" rows="3"
                  placeholder="Dejar vacío para mantener la actual">{{ old('direccion_fiscal', $cliente->direccion_fiscal) }}</textarea>
    </div>
    
    <div class="form-group">
        <label for="zona">Zona</label>
        <input type="text" name="zona" id="zona" 
               class="form-control" value="{{ old('zona', $cliente->zona) }}"
               placeholder="Dejar vacío para mantener: {{ $cliente->zona ?? 'Sin zona' }}">
    </div>
    
    <div class="form-group">
        <label for="notas">Notas</label>
        <textarea name="notas" id="notas" 
                  class="form-control" rows="3"
                  placeholder="Dejar vacío para mantener las actuales">{{ old('notas', $cliente->notas) }}</textarea>
    </div>
    
    <div class="form-actions">
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-paper-plane"></i> Enviar Solicitud de Edición
        </button>
        <a href="{{ route('vendedor.clientes.show', $cliente->id) }}" class="btn btn-secondary">Cancelar</a>
    </div>
</form>

<div class="info-box">
    <p><strong>Importante:</strong> Tu solicitud será revisada por un administrador. Recibirás una notificación cuando sea aprobada o rechazada.</p>
</div>
@endsection

