@extends('layouts.vendedor')

@section('title', 'Solicitar Nuevo Cliente')

@section('content')
<div class="page-header">
    <h1 class="page-title">Solicitar Nuevo Cliente</h1>
    <a href="{{ route('vendedor.dashboard') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Volver
    </a>
</div>

<form action="{{ route('vendedor.solicitar-cliente.store') }}" method="POST" class="form-container">
    @csrf
    
    <div class="form-group">
        <label for="nombre_empresa">Nombre de la Empresa *</label>
        <input type="text" name="nombre_empresa" id="nombre_empresa" 
               class="form-control" value="{{ old('nombre_empresa') }}" required>
    </div>
    
    <div class="form-group">
        <label for="rif">RIF *</label>
        <input type="text" name="rif" id="rif" 
               class="form-control" value="{{ old('rif') }}" required>
    </div>
    
    <div class="form-group">
        <label for="direccion_fiscal">Dirección Fiscal</label>
        <textarea name="direccion_fiscal" id="direccion_fiscal" 
                  class="form-control" rows="3">{{ old('direccion_fiscal') }}</textarea>
    </div>
    
    <div class="form-group">
        <label for="zona">Zona</label>
        <input type="text" name="zona" id="zona" 
               class="form-control" value="{{ old('zona') }}">
    </div>
    
    <div class="form-group">
        <label for="notas">Notas Adicionales</label>
        <textarea name="notas" id="notas" 
                  class="form-control" rows="3" 
                  placeholder="Información adicional sobre el cliente...">{{ old('notas') }}</textarea>
    </div>
    
    <div class="form-actions">
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-paper-plane"></i> Enviar Solicitud
        </button>
        <a href="{{ route('vendedor.dashboard') }}" class="btn btn-secondary">Cancelar</a>
    </div>
</form>

<div class="info-box">
    <p><strong>Nota:</strong> Tu solicitud será revisada por un administrador. Recibirás una notificación cuando sea aprobada o rechazada.</p>
</div>
@endsection

