<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>Login Vendedor - Portal de Vendedores</title>
    
    <!-- PWA Meta Tags -->
    <meta name="application-name" content="Portal de Vendedores">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="theme-color" content="#0d6efd">
    
    <!-- PWA Manifest -->
    <link rel="manifest" href="{{ asset('vendedor/manifest.json') }}">
    
    <!-- Styles -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="{{ asset('vendedor/assets/css/style.css') }}">
    
    <!-- Service Worker Registration -->
    <script>
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', function() {
                navigator.serviceWorker.register('{{ asset('vendedor/sw.js') }}', {
                    scope: '{{ url('/vendedor/') }}/'
                }).then(function(registration) {
                    console.log('[SW] Service Worker registrado:', registration.scope);
                }).catch(function(error) {
                    console.log('[SW] Error:', error);
                });
            });
        }
    </script>
</head>
<body class="glass-login-body">
    <div class="glass-login-container">
        <h2 class="glass-login-title">PORTAL DE VENDEDORES</h2>
        
        @if($errors->any())
            <div class="error-alert">
                @foreach($errors->all() as $error)
                    <p>{{ $error }}</p>
                @endforeach
            </div>
        @endif

        <form action="{{ route('vendedor.login') }}" method="POST">
            @csrf
            
            <div class="glass-form-group">
                <i class="fas fa-user glass-input-icon"></i>
                <input type="email" name="email" class="glass-input" placeholder="Usuario" value="{{ old('email') }}" required autofocus>
            </div>
            
            <div class="glass-form-group">
                <i class="fas fa-lock glass-input-icon"></i>
                <input type="password" name="password" class="glass-input" placeholder="Contraseña" required>
            </div>
            
            <button type="submit" class="glass-btn">LOGIN</button>
        </form>
    </div>
</body>
</html>

