<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Portal de Vendedores')</title>
    
    <!-- PWA Meta Tags -->
    <meta name="application-name" content="Portal de Vendedores">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="Vendedores">
    <meta name="description" content="Portal móvil para vendedores - Gestión de clientes y documentos">
    <meta name="theme-color" content="#0d6efd">
    
    <!-- PWA Manifest -->
    <link rel="manifest" href="{{ asset('vendedor/manifest.json') }}">
    
    <!-- Apple Touch Icons -->
    <link rel="apple-touch-icon" href="{{ asset('vendedor/assets/icons/icon-192x192.png') }}">
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="{{ asset('vendedor/assets/icons/icon-32x32.png') }}">
    
    <!-- Styles -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="{{ asset('vendedor/assets/css/style.css') }}">
    
    <!-- Service Worker Registration -->
    <script>
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', function() {
                navigator.serviceWorker.register('{{ asset('vendedor/sw.js') }}', {
                    scope: '{{ url('/vendedor/') }}/'
                }).then(function(registration) {
                    console.log('[SW] Service Worker registrado:', registration.scope);
                }).catch(function(error) {
                    console.log('[SW] Error:', error);
                });
            });
        }
    </script>
    
    @stack('styles')
</head>
<body>
    <div class="vendedor-container">
        <!-- Header -->
        <header class="vendedor-header">
            <div class="header-content">
                <h1 class="app-title">Portal de Vendedores</h1>
                <div class="header-actions">
                    <div id="connection-status" class="connection-status">
                        <i class="fas fa-wifi"></i> <span>En línea</span>
                    </div>
                    <button id="sync-pending-btn" class="btn-sync" title="Sincronizar documentos pendientes" style="display: none;">
                        <i class="fas fa-sync"></i>
                        <span id="offline-docs-badge" class="badge" style="display: none;">0</span>
                    </button>
                    <span class="user-name">{{ Auth::user()->nombre }}</span>
                    <form action="{{ route('logout') }}" method="POST" class="inline-form" id="logoutForm">
                        @csrf
                        <button type="submit" class="btn-logout" id="logoutBtn">
                            <i class="fas fa-sign-out-alt"></i> Salir
                        </button>
                    </form>
                </div>
            </div>
        </header>

        <!-- Main Content -->
        <main class="vendedor-main">
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-error">
                    {{ session('error') }}
                </div>
            @endif

            @if($errors->any())
                <div class="alert alert-error">
                    <ul>
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            @yield('content')
        </main>
    </div>

    <!-- PWA Scripts -->
    <script src="{{ asset('vendedor/assets/js/service-worker-register.js') }}"></script>
    <script src="{{ asset('vendedor/assets/js/pwa-manager.js') }}"></script>
    <script src="{{ asset('vendedor/assets/js/offline-document-manager.js') }}"></script>
    <script src="{{ asset('vendedor/assets/js/push-notifications.js') }}"></script>
    
    <script>
        // Asegurar que el botón de logout funcione correctamente
        document.addEventListener('DOMContentLoaded', function() {
            const logoutBtn = document.getElementById('logoutBtn');
            const logoutForm = document.getElementById('logoutForm');
            
            if (logoutBtn && logoutForm) {
                logoutBtn.addEventListener('click', function(e) {
                    // Prevenir doble envío
                    if (logoutForm.dataset.submitting === 'true') {
                        e.preventDefault();
                        return false;
                    }
                    
                    logoutForm.dataset.submitting = 'true';
                    logoutBtn.disabled = true;
                    logoutBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Saliendo...';
                    
                    // Forzar envío del formulario
                    logoutForm.submit();
                });
            }
        });
    </script>
    
    @stack('scripts')
</body>
</html>

