@extends('layouts.app')

@section('title', 'Nuevo Usuario')

@section('content')
<div class="page-header">
    <h1 class="page-title">Nuevo Usuario</h1>
    <a href="{{ route('admin.usuarios.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Volver
    </a>
</div>

<form action="{{ route('admin.usuarios.store') }}" method="POST" class="form-container">
    @csrf
    
    <div class="form-group">
        <label for="nombre">Nombre *</label>
        <input type="text" name="nombre" id="nombre" 
               class="form-control" value="{{ old('nombre') }}" required>
    </div>
    
    <div class="form-group">
        <label for="email">Email *</label>
        <input type="email" name="email" id="email" 
               class="form-control" value="{{ old('email') }}" required>
    </div>
    
    <div class="form-group">
        <label for="password">Contraseña *</label>
        <input type="password" name="password" id="password" 
               class="form-control" required minlength="8">
    </div>
    
    <div class="form-group">
        <label for="password_confirmation">Confirmar Contraseña *</label>
        <input type="password" name="password_confirmation" id="password_confirmation" 
               class="form-control" required minlength="8">
    </div>
    
    <div class="form-group">
        <label for="rol_id">Rol *</label>
        <select name="rol_id" id="rol_id" class="form-control" required>
            <option value="">Seleccionar...</option>
            @foreach($roles as $rol)
                <option value="{{ $rol->id }}" {{ old('rol_id') == $rol->id ? 'selected' : '' }}>
                    {{ $rol->nombre_rol }}
                </option>
            @endforeach
        </select>
    </div>
    
    <div class="form-group">
        <label>
            <input type="checkbox" name="activo" value="1" {{ old('activo', true) ? 'checked' : '' }}>
            Usuario Activo
        </label>
    </div>
    
    <div class="form-actions">
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Guardar Usuario
        </button>
        <a href="{{ route('admin.usuarios.index') }}" class="btn btn-secondary">Cancelar</a>
    </div>
</form>
@endsection

