@extends('layouts.app')

@section('title', 'Tipos de Documento')

@section('content')
<div class="page-header">
    <h1 class="page-title">Gestión de Tipos de Documento</h1>
    <a href="{{ route('admin.tipos-documento.create') }}" class="btn btn-primary">
        <i class="fas fa-plus"></i> Nuevo Tipo de Documento
    </a>
</div>

<div class="table-container">
    <table class="data-table">
        <thead>
            <tr>
                <th>Nombre</th>
                <th>Descripción</th>
                <th>Estado</th>
                <th>Documentos</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            @forelse($tiposDocumento as $tipo)
                <tr>
                    <td>{{ $tipo->nombre }}</td>
                    <td>{{ $tipo->descripcion ?? '-' }}</td>
                    <td>
                        <span class="badge {{ $tipo->activo ? 'badge-success' : 'badge-danger' }}">
                            {{ $tipo->activo ? 'Activo' : 'Inactivo' }}
                        </span>
                    </td>
                    <td>
                        <span class="badge badge-info">{{ $tipo->documentos()->count() }}</span>
                    </td>
                    <td class="actions">
                        <a href="{{ route('admin.tipos-documento.edit', $tipo->id) }}" 
                           class="btn btn-sm btn-warning btn-icon" title="Editar">
                            <i class="fas fa-edit"></i>
                        </a>
                        @if($tipo->documentos()->count() === 0)
                        <form action="{{ route('admin.tipos-documento.destroy', $tipo->id) }}" 
                              method="POST" class="inline-form"
                              onsubmit="return confirm('¿Estás seguro de eliminar este tipo de documento?');">
                            @csrf @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-danger btn-icon" title="Eliminar">
                                <i class="fas fa-trash-alt"></i>
                            </button>
                        </form>
                        @endif
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="5" class="text-center">No hay tipos de documento registrados.</td>
                </tr>
            @endforelse
        </tbody>
    </table>
    {{ $tiposDocumento->links() }}
</div>
@endsection

