@extends('layouts.app')

@section('title', 'Reportes')

@section('content')
<div class="page-header">
    <h1 class="page-title">
        <i class="fas fa-chart-bar"></i> Reportes Avanzados
    </h1>
</div>

<div class="reports-grid">
    <div class="report-card">
        <div class="report-icon">
            <i class="fas fa-exclamation-triangle"></i>
        </div>
        <div class="report-content">
            <h3>Documentos Vencidos por Vendedor</h3>
            <p>Reporte detallado de documentos vencidos agrupados por vendedor</p>
            <a href="{{ route('admin.reportes.documentos-vencidos-vendedor') }}" class="btn btn-danger">
                <i class="fas fa-file-alt"></i> Ver Reporte
            </a>
        </div>
    </div>

    <div class="report-card">
        <div class="report-icon">
            <i class="fas fa-clock"></i>
        </div>
        <div class="report-content">
            <h3>Documentos Próximos a Vencer</h3>
            <p>Documentos que vencen en los próximos meses, agrupados por mes</p>
            <a href="{{ route('admin.reportes.documentos-proximos-vencer') }}" class="btn btn-warning">
                <i class="fas fa-file-alt"></i> Ver Reporte
            </a>
        </div>
    </div>

    <div class="report-card">
        <div class="report-icon">
            <i class="fas fa-user-tie"></i>
        </div>
        <div class="report-content">
            <h3>Actividad de Vendedores</h3>
            <p>Estadísticas de actividad de vendedores (documentos, solicitudes, clientes)</p>
            <a href="{{ route('admin.reportes.actividad-vendedores') }}" class="btn btn-primary">
                <i class="fas fa-file-alt"></i> Ver Reporte
            </a>
        </div>
    </div>

    <div class="report-card">
        <div class="report-icon">
            <i class="fas fa-file-slash"></i>
        </div>
        <div class="report-content">
            <h3>Clientes Sin Documentos</h3>
            <p>Lista de clientes que no tienen ningún documento registrado</p>
            <a href="{{ route('admin.reportes.clientes-sin-documentos') }}" class="btn btn-info">
                <i class="fas fa-file-alt"></i> Ver Reporte
            </a>
        </div>
    </div>
</div>

@push('styles')
<style>
.reports-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 2rem;
    margin-top: 2rem;
}

.report-card {
    background: var(--white);
    border-radius: 12px;
    padding: 2rem;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    transition: transform 0.2s, box-shadow 0.2s;
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.report-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 16px rgba(0, 0, 0, 0.15);
}

.report-icon {
    width: 60px;
    height: 60px;
    background: linear-gradient(135deg, var(--primary-color) 0%, #0056b3 100%);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: var(--white);
    font-size: 1.5rem;
}

.report-content h3 {
    margin: 0 0 0.5rem;
    color: var(--dark-color);
    font-size: 1.2rem;
}

.report-content p {
    margin: 0 0 1rem;
    color: var(--secondary-color);
    line-height: 1.6;
}

.report-content .btn {
    width: 100%;
    justify-content: center;
}

@media (max-width: 768px) {
    .reports-grid {
        grid-template-columns: 1fr;
    }
}
</style>
@endpush
@endsection

