@extends('layouts.app')

@section('title', 'Reporte: Actividad de Vendedores')

@section('content')
<div class="page-header">
    <h1 class="page-title">
        <i class="fas fa-user-tie"></i> Actividad de Vendedores
    </h1>
    <div class="header-actions">
        <a href="{{ route('admin.reportes.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Volver
        </a>
    </div>
</div>

<div class="card" style="margin-bottom: 2rem;">
    <div class="card-body">
        <form method="GET" action="{{ route('admin.reportes.actividad-vendedores') }}" class="filters-form">
            <div class="filters-grid">
                <div class="form-group">
                    <label class="form-label" for="fecha_inicio">Fecha Inicio</label>
                    <input type="date" name="fecha_inicio" id="fecha_inicio" class="form-control" value="{{ $fechaInicio }}">
                </div>
                <div class="form-group">
                    <label class="form-label" for="fecha_fin">Fecha Fin</label>
                    <input type="date" name="fecha_fin" id="fecha_fin" class="form-control" value="{{ $fechaFin }}">
                </div>
            </div>
            <div class="filters-actions">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-filter"></i> Aplicar Filtros
                </button>
            </div>
        </form>
    </div>
</div>

<div class="table-container">
    <table class="data-table">
        <thead>
            <tr>
                <th>Vendedor</th>
                <th>Email</th>
                <th>Total Clientes</th>
                <th>Documentos Subidos</th>
                <th>Solicitudes Creación</th>
                <th>Solicitudes Edición</th>
                <th>Total Actividad</th>
            </tr>
        </thead>
        <tbody>
            @forelse($actividades as $actividad)
                <tr>
                    <td><strong>{{ $actividad['vendedor']->nombre }}</strong></td>
                    <td>{{ $actividad['vendedor']->email }}</td>
                    <td>
                        <span class="badge badge-info">{{ $actividad['clientes'] }}</span>
                    </td>
                    <td>
                        <span class="badge badge-success">{{ $actividad['documentos_subidos'] }}</span>
                    </td>
                    <td>
                        <span class="badge badge-warning">{{ $actividad['solicitudes_creacion'] }}</span>
                    </td>
                    <td>
                        <span class="badge badge-warning">{{ $actividad['solicitudes_edicion'] }}</span>
                    </td>
                    <td>
                        <strong>{{ $actividad['documentos_subidos'] + $actividad['solicitudes_creacion'] + $actividad['solicitudes_edicion'] }}</strong>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="7" class="text-center">
                        <i class="fas fa-inbox"></i> No hay actividad para mostrar.
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
@endsection

