@extends('layouts.app')

@section('title', 'Notificaciones')

@section('content')
<div class="page-header">
    <h1 class="page-title">
        <i class="fas fa-bell"></i> Gestión de Notificaciones
    </h1>
</div>

<div class="notificaciones-container">
    <!-- Formularios en Grid -->
    <div class="notificaciones-grid">
        <!-- Formulario Individual -->
        <div class="notification-card card-individual">
            <div class="notification-card-header">
                <div class="notification-icon">
                    <i class="fas fa-user"></i>
                </div>
                <h3>Enviar a un Vendedor</h3>
                <p class="notification-subtitle">Notificación personalizada</p>
            </div>
            <div class="notification-card-body">
                <form action="{{ route('admin.notificaciones.store') }}" method="POST" class="notification-form">
                    @csrf
                    <div class="form-group">
                        <label class="form-label" for="destinatario_id">
                            <i class="fas fa-user-circle"></i> Vendedor
                        </label>
                        <select name="destinatario_id" id="destinatario_id" class="form-select" required>
                            <option value="">Seleccione un vendedor</option>
                            @foreach($vendedores as $vendedor)
                                <option value="{{ $vendedor->id }}" {{ old('destinatario_id') == $vendedor->id ? 'selected' : '' }}>
                                    {{ $vendedor->nombre }} ({{ $vendedor->email }})
                                </option>
                            @endforeach
                        </select>
                        @error('destinatario_id')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label class="form-label" for="titulo">
                            <i class="fas fa-heading"></i> Título
                        </label>
                        <input type="text" name="titulo" id="titulo" class="form-control" 
                               value="{{ old('titulo') }}" required maxlength="255" 
                               placeholder="Ej: Recordatorio importante">
                        @error('titulo')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label class="form-label" for="mensaje">
                            <i class="fas fa-comment-alt"></i> Mensaje
                        </label>
                        <textarea name="mensaje" id="mensaje" class="form-control" rows="4" required
                                  placeholder="Escribe el mensaje de la notificación...">{{ old('mensaje') }}</textarea>
                        @error('mensaje')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label" for="tipo">
                                <i class="fas fa-tag"></i> Tipo
                            </label>
                            <select name="tipo" id="tipo" class="form-select">
                                <option value="general" {{ old('tipo') == 'general' ? 'selected' : '' }}>
                                    📢 General
                                </option>
                                <option value="alerta" {{ old('tipo') == 'alerta' ? 'selected' : '' }}>
                                    ⚠️ Alerta
                                </option>
                                <option value="importante" {{ old('tipo') == 'importante' ? 'selected' : '' }}>
                                    🔴 Importante
                                </option>
                                <option value="recordatorio" {{ old('tipo') == 'recordatorio' ? 'selected' : '' }}>
                                    📝 Recordatorio
                                </option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group checkbox-group">
                        <label class="checkbox-label">
                            <input type="checkbox" name="enviar_push" value="1" {{ old('enviar_push') ? 'checked' : '' }}>
                            <span class="checkbox-custom"></span>
                            <span class="checkbox-text">
                                <i class="fas fa-mobile-alt"></i> Enviar también como Push Notification
                            </span>
                        </label>
                    </div>

                    <div class="form-group">
                        <button type="submit" class="btn btn-primary btn-block">
                            <i class="fas fa-paper-plane"></i> Enviar Notificación
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Formulario Masivo -->
        <div class="notification-card card-masivo">
            <div class="notification-card-header">
                <div class="notification-icon icon-broadcast">
                    <i class="fas fa-broadcast-tower"></i>
                </div>
                <h3>Enviar a Todos</h3>
                <p class="notification-subtitle">Notificación masiva</p>
            </div>
            <div class="notification-card-body">
                <form action="{{ route('admin.notificaciones.enviar-todos') }}" method="POST" 
                      class="notification-form"
                      onsubmit="return confirm('¿Estás seguro de enviar esta notificación a todos los vendedores?');">
                    @csrf
                    <div class="form-group">
                        <label class="form-label" for="titulo_todos">
                            <i class="fas fa-heading"></i> Título
                        </label>
                        <input type="text" name="titulo" id="titulo_todos" class="form-control" 
                               value="{{ old('titulo') }}" required maxlength="255"
                               placeholder="Ej: Aviso importante para todos">
                    </div>

                    <div class="form-group">
                        <label class="form-label" for="mensaje_todos">
                            <i class="fas fa-comment-alt"></i> Mensaje
                        </label>
                        <textarea name="mensaje" id="mensaje_todos" class="form-control" rows="4" required
                                  placeholder="Escribe el mensaje para todos los vendedores...">{{ old('mensaje') }}</textarea>
                    </div>

                    <div class="form-group">
                        <label class="form-label" for="tipo_todos">
                            <i class="fas fa-tag"></i> Tipo
                        </label>
                        <select name="tipo" id="tipo_todos" class="form-select">
                            <option value="general">📢 General</option>
                            <option value="alerta">⚠️ Alerta</option>
                            <option value="importante">🔴 Importante</option>
                            <option value="recordatorio">📝 Recordatorio</option>
                        </select>
                    </div>

                    <div class="form-group checkbox-group">
                        <label class="checkbox-label">
                            <input type="checkbox" name="enviar_push" value="1">
                            <span class="checkbox-custom"></span>
                            <span class="checkbox-text">
                                <i class="fas fa-mobile-alt"></i> Enviar también como Push Notification
                            </span>
                        </label>
                    </div>

                    <div class="form-group">
                        <button type="submit" class="btn btn-warning btn-block">
                            <i class="fas fa-broadcast-tower"></i> Enviar a Todos los Vendedores
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Historial de Notificaciones -->
    @if($notificacionesRecientes->isNotEmpty())
    <div class="notification-history">
        <div class="history-header">
            <h3>
                <i class="fas fa-history"></i> Notificaciones Recientes
            </h3>
            <span class="badge badge-info">{{ $notificacionesRecientes->count() }}</span>
        </div>
        <div class="table-container">
            <table class="data-table">
                <thead>
                    <tr>
                        <th><i class="fas fa-calendar"></i> Fecha</th>
                        <th><i class="fas fa-user"></i> Destinatario</th>
                        <th><i class="fas fa-heading"></i> Título</th>
                        <th><i class="fas fa-tag"></i> Tipo</th>
                        <th><i class="fas fa-check-circle"></i> Estado</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($notificacionesRecientes as $notificacion)
                    <tr>
                        <td>
                            <span class="date-time">
                                <i class="fas fa-clock"></i>
                                {{ $notificacion->created_at->format('d/m/Y') }}
                                <small>{{ $notificacion->created_at->format('H:i') }}</small>
                            </span>
                        </td>
                        <td>
                            <div class="user-info">
                                <i class="fas fa-user-circle"></i>
                                {{ $notificacion->destinatario->nombre }}
                            </div>
                        </td>
                        <td>
                            <strong>{{ $notificacion->titulo }}</strong>
                        </td>
                        <td>
                            @php
                                $tipoIcons = [
                                    'general' => '📢',
                                    'alerta' => '⚠️',
                                    'importante' => '🔴',
                                    'recordatorio' => '📝'
                                ];
                                $tipoColors = [
                                    'general' => 'badge-info',
                                    'alerta' => 'badge-warning',
                                    'importante' => 'badge-danger',
                                    'recordatorio' => 'badge-primary'
                                ];
                                $icon = $tipoIcons[$notificacion->tipo] ?? '📢';
                                $color = $tipoColors[$notificacion->tipo] ?? 'badge-info';
                            @endphp
                            <span class="badge {{ $color }}">
                                {{ $icon }} {{ ucfirst($notificacion->tipo) }}
                            </span>
                        </td>
                        <td>
                            <span class="badge {{ $notificacion->leida ? 'badge-success' : 'badge-warning' }}">
                                <i class="fas fa-{{ $notificacion->leida ? 'check' : 'clock' }}"></i>
                                {{ $notificacion->leida ? 'Leída' : 'No leída' }}
                            </span>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    @else
    <div class="empty-state">
        <i class="fas fa-bell-slash"></i>
        <p>No hay notificaciones recientes</p>
    </div>
    @endif
</div>

@push('styles')
<style>
.notificaciones-container {
    max-width: 1400px;
    margin: 0 auto;
    padding: 0 1rem;
}

.notificaciones-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(500px, 1fr));
    gap: 2rem;
    margin-bottom: 2rem;
}

.notification-card {
    background: var(--white);
    border-radius: 12px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    overflow: hidden;
    transition: transform 0.3s, box-shadow 0.3s;
}

.notification-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 16px rgba(0, 0, 0, 0.15);
}

.notification-card-header {
    padding: 1.5rem;
    background: linear-gradient(135deg, var(--primary-color) 0%, #0056b3 100%);
    color: var(--white);
    text-align: center;
}

.card-masivo .notification-card-header {
    background: linear-gradient(135deg, var(--warning-color) 0%, #e0a800 100%);
}

.notification-icon {
    width: 60px;
    height: 60px;
    margin: 0 auto 1rem;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
}

.icon-broadcast {
    background: rgba(255, 255, 255, 0.25);
}

.notification-card-header h3 {
    margin: 0 0 0.5rem;
    font-size: 1.25rem;
    font-weight: 600;
}

.notification-subtitle {
    margin: 0;
    opacity: 0.9;
    font-size: 0.9rem;
}

.notification-card-body {
    padding: 1.5rem;
}

.notification-form .form-group {
    margin-bottom: 1.25rem;
}

.notification-form .form-label {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: 500;
    margin-bottom: 0.5rem;
    color: var(--dark-color);
}

.notification-form .form-label i {
    color: var(--primary-color);
    font-size: 0.9rem;
}

.checkbox-group {
    padding: 1rem;
    background: var(--light-color);
    border-radius: 8px;
    border: 2px dashed var(--border-color);
}

.checkbox-label {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    cursor: pointer;
    margin: 0;
}

.checkbox-label input[type="checkbox"] {
    display: none;
}

.checkbox-custom {
    width: 20px;
    height: 20px;
    border: 2px solid var(--primary-color);
    border-radius: 4px;
    position: relative;
    transition: all 0.3s;
}

.checkbox-label input[type="checkbox"]:checked + .checkbox-custom {
    background: var(--primary-color);
    border-color: var(--primary-color);
}

.checkbox-label input[type="checkbox"]:checked + .checkbox-custom::after {
    content: '✓';
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    color: var(--white);
    font-weight: bold;
    font-size: 0.875rem;
}

.checkbox-text {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: 500;
}

.btn-block {
    width: 100%;
    padding: 0.875rem;
    font-size: 1rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.notification-history {
    background: var(--white);
    border-radius: 12px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    overflow: hidden;
    margin-top: 2rem;
}

.history-header {
    padding: 1.5rem;
    background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
    color: var(--white);
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.history-header h3 {
    margin: 0;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-size: 1.25rem;
}

.date-time {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.date-time small {
    color: var(--secondary-color);
    font-size: 0.85rem;
}

.user-info {
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.user-info i {
    color: var(--primary-color);
}

.empty-state {
    text-align: center;
    padding: 3rem;
    background: var(--white);
    border-radius: 12px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    margin-top: 2rem;
}

.empty-state i {
    font-size: 4rem;
    color: var(--secondary-color);
    margin-bottom: 1rem;
    opacity: 0.5;
}

.empty-state p {
    color: var(--secondary-color);
    font-size: 1.1rem;
}

@media (max-width: 768px) {
    .notificaciones-grid {
        grid-template-columns: 1fr;
        gap: 1.5rem;
    }
    
    .notification-card-header {
        padding: 1rem;
    }
    
    .notification-card-body {
        padding: 1rem;
    }
}
</style>
@endpush
@endsection
