@extends('layouts.app')

@section('title', 'Configuración del Sistema')

@section('content')
<div class="page-header">
    <h1 class="page-title">
        <i class="fas fa-cog"></i> Configuración del Sistema
    </h1>
</div>

<form method="POST" action="{{ route('admin.configuracion.update') }}" id="configForm">
    @csrf
    @method('PUT')

    @foreach($configuraciones as $categoria => $configs)
    <div class="card" style="margin-bottom: 2rem;">
        <div class="card-header">
            <h3>
                @if($categoria === 'documentos')
                    <i class="fas fa-file-alt"></i> Configuración de Documentos
                @elseif($categoria === 'sistema')
                    <i class="fas fa-server"></i> Configuración del Sistema
                @elseif($categoria === 'apariencia')
                    <i class="fas fa-palette"></i> Apariencia
                @else
                    <i class="fas fa-cog"></i> {{ ucfirst($categoria) }}
                @endif
            </h3>
        </div>
        <div class="card-body">
            @foreach($configs as $config)
            <div class="form-group">
                <label class="form-label" for="config_{{ $config->clave }}">
                    {{ str_replace('_', ' ', ucwords($config->clave, '_')) }}
                    @if($config->descripcion)
                        <small style="display: block; color: var(--secondary-color); font-weight: normal; margin-top: 0.25rem;">
                            {{ $config->descripcion }}
                        </small>
                    @endif
                </label>
                
                @if($config->tipo === 'boolean')
                    <div class="form-check">
                        <input type="checkbox" 
                               name="configuraciones[{{ $config->clave }}]" 
                               id="config_{{ $config->clave }}"
                               value="1"
                               class="form-check-input"
                               {{ filter_var($config->valor, FILTER_VALIDATE_BOOLEAN) ? 'checked' : '' }}>
                        <label class="form-check-label" for="config_{{ $config->clave }}">
                            {{ filter_var($config->valor, FILTER_VALIDATE_BOOLEAN) ? 'Activado' : 'Desactivado' }}
                        </label>
                    </div>
                @elseif($config->tipo === 'number')
                    <input type="number" 
                           name="configuraciones[{{ $config->clave }}]" 
                           id="config_{{ $config->clave }}"
                           class="form-control"
                           value="{{ $config->valor }}"
                           min="0"
                           step="{{ str_contains($config->clave, 'mb') ? '0.1' : '1' }}">
                @elseif($config->tipo === 'json')
                    <textarea name="configuraciones[{{ $config->clave }}]" 
                              id="config_{{ $config->clave }}"
                              class="form-control"
                              rows="3">{{ $config->valor }}</textarea>
                @else
                    @if(str_contains($config->clave, 'color'))
                        <div style="display: flex; gap: 0.5rem; align-items: center;">
                            <input type="color" 
                                   name="configuraciones[{{ $config->clave }}]" 
                                   id="config_{{ $config->clave }}"
                                   value="{{ $config->valor }}"
                                   style="width: 60px; height: 40px; border: 1px solid var(--border-color); border-radius: 4px;">
                            <input type="text" 
                                   value="{{ $config->valor }}"
                                   class="form-control"
                                   readonly
                                   style="flex: 1;">
                        </div>
                    @else
                        <input type="text" 
                               name="configuraciones[{{ $config->clave }}]" 
                               id="config_{{ $config->clave }}"
                               class="form-control"
                               value="{{ $config->valor }}">
                    @endif
                @endif
            </div>
            @endforeach
        </div>
    </div>
    @endforeach

    <div class="form-actions">
        <button type="submit" class="btn btn-primary btn-lg">
            <i class="fas fa-save"></i> Guardar Configuraciones
        </button>
        <a href="{{ route('admin.dashboard') }}" class="btn btn-secondary btn-lg">
            <i class="fas fa-times"></i> Cancelar
        </a>
    </div>
</form>

@push('styles')
<style>
.form-actions {
    display: flex;
    gap: 1rem;
    margin-top: 2rem;
    padding-top: 2rem;
    border-top: 2px solid var(--border-color);
}

.form-check {
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.form-check-input {
    width: 20px;
    height: 20px;
    cursor: pointer;
}

.form-check-label {
    cursor: pointer;
    user-select: none;
}
</style>
@endpush

@push('scripts')
<script>
document.getElementById('configForm').addEventListener('submit', function(e) {
    const btn = this.querySelector('button[type="submit"]');
    btn.disabled = true;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Guardando...';
});
</script>
@endpush
@endsection

