@extends('layouts.app')

@section('title', 'Ficha de Cliente: ' . $cliente->nombre_empresa)

@section('content')
<div class="page-header">
    <h1 class="page-title">Ficha de Cliente</h1>
    <div class="header-actions">
        <a href="{{ route('admin.exportar.documentos-cliente', $cliente->id) }}" class="btn btn-success">
            <i class="fas fa-file-excel"></i> Exportar Documentos
        </a>
        <a href="{{ route('admin.clientes.edit', $cliente->id) }}" class="btn btn-warning">
            <i class="fas fa-edit"></i> Editar
        </a>
        <a href="{{ route('admin.clientes.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Volver
        </a>
    </div>
</div>

<div class="cliente-ficha">
    <div class="info-section">
        <h2>Información General</h2>
        <div class="info-grid">
            <div class="info-item">
                <label>Nombre de la Empresa:</label>
                <span>{{ $cliente->nombre_empresa }}</span>
            </div>
            <div class="info-item">
                <label>RIF:</label>
                <span>{{ $cliente->rif }}</span>
            </div>
            <div class="info-item">
                <label>Dirección Fiscal:</label>
                <span>{{ $cliente->direccion_fiscal ?? '-' }}</span>
            </div>
            <div class="info-item">
                <label>Zona:</label>
                <span>{{ $cliente->zona ?? '-' }}</span>
            </div>
            <div class="info-item">
                <label>Vendedor Asignado:</label>
                <span>{{ $cliente->vendedor ? $cliente->vendedor->nombre : 'Sin asignar' }}</span>
            </div>
            <div class="info-item">
                <label>Estatus:</label>
                <span class="badge status-{{ $estatus['clase'] }}">
                    <i class="{{ $estatus['icono'] }}"></i> {{ $estatus['texto'] }}
                </span>
            </div>
        </div>
        @if($cliente->notas)
        <div class="info-item">
            <label>Notas:</label>
            <p>{{ $cliente->notas }}</p>
        </div>
        @endif
    </div>

    <div class="info-section">
        <h2>Documentos</h2>
        
        <form action="{{ route('admin.documentos.store') }}" method="POST" enctype="multipart/form-data" class="upload-form">
            @csrf
            <input type="hidden" name="cliente_id" value="{{ $cliente->id }}">
            
            <div class="form-row">
                <div class="form-group">
                    <label for="tipo_documento_id">Tipo de Documento *</label>
                    <select name="tipo_documento_id" id="tipo_documento_id" class="form-control" required>
                        <option value="">Seleccionar...</option>
                        @foreach(\App\Models\TipoDocumento::activos()->get() as $tipo)
                            <option value="{{ $tipo->id }}">{{ $tipo->nombre }}</option>
                        @endforeach
                    </select>
                </div>
                
                <div class="form-group">
                    <label for="archivo">Archivo *</label>
                    <input type="file" name="archivo" id="archivo" class="form-control" 
                           accept=".pdf,.jpg,.jpeg,.png" required>
                </div>
                
                <div class="form-group">
                    <label for="fecha_vencimiento">Fecha de Vencimiento</label>
                    <input type="date" name="fecha_vencimiento" id="fecha_vencimiento" class="form-control">
                </div>
                
                <div class="form-group">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-upload"></i> Subir Documento
                    </button>
                </div>
            </div>
        </form>
        
        <div class="documentos-list">
            @forelse($cliente->documentos as $documento)
                <div class="documento-item">
                    <div class="documento-info">
                        <i class="fas fa-file-alt"></i>
                        <div>
                            <strong>{{ $documento->tipoDocumento->nombre }}</strong>
                            <small>{{ $documento->nombre_archivo }}</small>
                            @if($documento->fecha_vencimiento)
                                <small>
                                    Vence: {{ $documento->fecha_vencimiento->format('d/m/Y') }}
                                    @if($documento->esta_vencido)
                                        <span class="badge badge-danger">Vencido</span>
                                    @elseif($documento->proximo_a_vencer)
                                        <span class="badge badge-warning">Próximo a vencer</span>
                                    @endif
                                </small>
                            @endif
                        </div>
                    </div>
                    <div class="documento-actions">
                        <a href="{{ route('admin.documentos.download', $documento->id) }}" 
                           class="btn btn-sm btn-info" target="_blank">
                            <i class="fas fa-download"></i>
                        </a>
                        <form action="{{ route('admin.documentos.destroy', $documento->id) }}" 
                              method="POST" class="inline-form"
                              onsubmit="return confirm('¿Eliminar este documento?');">
                            @csrf @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-danger">
                                <i class="fas fa-trash"></i>
                            </button>
                        </form>
                    </div>
                </div>
            @empty
                <p class="text-muted">No hay documentos registrados.</p>
            @endforelse
        </div>
    </div>

    @if($cliente->historialCambios->isNotEmpty())
    <div class="info-section">
        <h2>Historial de Cambios</h2>
        <div class="historial-list">
            @foreach($cliente->historialCambios->sortByDesc('created_at') as $historial)
                <div class="historial-item">
                    <div class="historial-date">{{ $historial->created_at->format('d/m/Y H:i') }}</div>
                    <div class="historial-user">{{ $historial->usuario->nombre }}</div>
                    <div class="historial-action">{{ $historial->accion_realizada }}</div>
                </div>
            @endforeach
        </div>
    </div>
    @endif
</div>
@endsection

