@extends('layouts.app')

@section('title', 'Nuevo Cliente')

@section('content')
<div class="page-header">
    <h1 class="page-title">Nuevo Cliente</h1>
    <a href="{{ route('admin.clientes.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Volver
    </a>
</div>

<form action="{{ route('admin.clientes.store') }}" method="POST" class="form-container">
    @csrf
    
    <div class="form-group">
        <label for="nombre_empresa">Nombre de la Empresa *</label>
        <input type="text" name="nombre_empresa" id="nombre_empresa" 
               class="form-control" value="{{ old('nombre_empresa') }}" required>
    </div>
    
    <div class="form-group">
        <label for="rif">RIF *</label>
        <input type="text" name="rif" id="rif" 
               class="form-control" value="{{ old('rif') }}" required>
    </div>
    
    <div class="form-group">
        <label for="direccion_fiscal">Dirección Fiscal</label>
        <textarea name="direccion_fiscal" id="direccion_fiscal" 
                  class="form-control" rows="3">{{ old('direccion_fiscal') }}</textarea>
    </div>
    
    <div class="form-group">
        <label for="zona">Zona</label>
        <input type="text" name="zona" id="zona" 
               class="form-control" value="{{ old('zona') }}">
    </div>
    
    <div class="form-group">
        <label for="vendedor_id">Vendedor Asignado</label>
        <select name="vendedor_id" id="vendedor_id" class="form-control">
            <option value="">Sin asignar</option>
            @foreach($vendedores as $vendedor)
                <option value="{{ $vendedor->id }}" {{ old('vendedor_id') == $vendedor->id ? 'selected' : '' }}>
                    {{ $vendedor->nombre }}
                </option>
            @endforeach
        </select>
    </div>
    
    <div class="form-group">
        <label for="notas">Notas</label>
        <textarea name="notas" id="notas" 
                  class="form-control" rows="3">{{ old('notas') }}</textarea>
    </div>
    
    <div class="form-actions">
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Guardar Cliente
        </button>
        <a href="{{ route('admin.clientes.index') }}" class="btn btn-secondary">Cancelar</a>
    </div>
</form>
@endsection

