@extends('layouts.app')

@section('title', 'Auditoría de Accesos')

@section('content')
<div class="page-header">
    <h1 class="page-title">
        <i class="fas fa-shield-alt"></i> Auditoría de Accesos
    </h1>
</div>

<!-- Estadísticas -->
<div class="stats-grid" style="margin-bottom: 2rem;">
    <div class="stat-card">
        <h3>Total de Accesos</h3>
        <p class="stat-number">{{ $estadisticas['total'] }}</p>
    </div>
    <div class="stat-card stat-success">
        <h3>Logins Exitosos</h3>
        <p class="stat-number">{{ $estadisticas['login_exitoso'] }}</p>
    </div>
    <div class="stat-card stat-danger">
        <h3>Logins Fallidos</h3>
        <p class="stat-number">{{ $estadisticas['login_fallido'] }}</p>
    </div>
    <div class="stat-card stat-info">
        <h3>Hoy</h3>
        <p class="stat-number">{{ $estadisticas['hoy'] }}</p>
    </div>
</div>

<!-- Filtros -->
<div class="card" style="margin-bottom: 2rem;">
    <div class="card-header">
        <h3><i class="fas fa-filter"></i> Filtros</h3>
    </div>
    <div class="card-body">
        <form method="GET" action="{{ route('admin.auditoria.index') }}" class="filters-form">
            <div class="filters-grid">
                <div class="form-group">
                    <label class="form-label" for="tipo">Tipo</label>
                    <select name="tipo" id="tipo" class="form-select">
                        <option value="">Todos</option>
                        <option value="login_exitoso" {{ request('tipo') == 'login_exitoso' ? 'selected' : '' }}>Login Exitoso</option>
                        <option value="login_fallido" {{ request('tipo') == 'login_fallido' ? 'selected' : '' }}>Login Fallido</option>
                        <option value="logout" {{ request('tipo') == 'logout' ? 'selected' : '' }}>Logout</option>
                        <option value="acceso_denegado" {{ request('tipo') == 'acceso_denegado' ? 'selected' : '' }}>Acceso Denegado</option>
                    </select>
                </div>

                <div class="form-group">
                    <label class="form-label" for="usuario_id">Usuario</label>
                    <select name="usuario_id" id="usuario_id" class="form-select">
                        <option value="">Todos los usuarios</option>
                        @foreach($usuarios as $usuario)
                            <option value="{{ $usuario->id }}" {{ request('usuario_id') == $usuario->id ? 'selected' : '' }}>
                                {{ $usuario->nombre }} ({{ $usuario->email }})
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label class="form-label" for="fecha_inicio">Fecha Inicio</label>
                    <input type="date" name="fecha_inicio" id="fecha_inicio" class="form-control" value="{{ request('fecha_inicio') }}">
                </div>

                <div class="form-group">
                    <label class="form-label" for="fecha_fin">Fecha Fin</label>
                    <input type="date" name="fecha_fin" id="fecha_fin" class="form-control" value="{{ request('fecha_fin') }}">
                </div>

                <div class="form-group">
                    <label class="form-label" for="ip_address">IP Address</label>
                    <input type="text" name="ip_address" id="ip_address" class="form-control" value="{{ request('ip_address') }}" placeholder="192.168.1.1">
                </div>
            </div>

            <div class="filters-actions">
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-filter"></i> Aplicar Filtros
                </button>
                <a href="{{ route('admin.auditoria.index') }}" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Limpiar
                </a>
            </div>
        </form>
    </div>
</div>

<!-- Tabla de Accesos -->
<div class="table-container">
    <table class="data-table">
        <thead>
            <tr>
                <th>Fecha/Hora</th>
                <th>Usuario</th>
                <th>Email</th>
                <th>Tipo</th>
                <th>IP Address</th>
                <th>Detalles</th>
            </tr>
        </thead>
        <tbody>
            @forelse($accesos as $acceso)
                <tr>
                    <td>{{ $acceso->created_at->format('d/m/Y H:i:s') }}</td>
                    <td>
                        @if($acceso->usuario)
                            {{ $acceso->usuario->nombre }}
                        @else
                            <span class="text-muted">-</span>
                        @endif
                    </td>
                    <td>{{ $acceso->email ?? '-' }}</td>
                    <td>
                        <span class="badge 
                            @if($acceso->tipo === 'login_exitoso') badge-success
                            @elseif($acceso->tipo === 'login_fallido') badge-danger
                            @elseif($acceso->tipo === 'logout') badge-info
                            @else badge-warning
                            @endif">
                            @if($acceso->tipo === 'login_exitoso')
                                <i class="fas fa-check-circle"></i> Login Exitoso
                            @elseif($acceso->tipo === 'login_fallido')
                                <i class="fas fa-times-circle"></i> Login Fallido
                            @elseif($acceso->tipo === 'logout')
                                <i class="fas fa-sign-out-alt"></i> Logout
                            @else
                                <i class="fas fa-ban"></i> Acceso Denegado
                            @endif
                        </span>
                    </td>
                    <td><code>{{ $acceso->ip_address }}</code></td>
                    <td>{{ $acceso->detalles ?? '-' }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" class="text-center">
                        <i class="fas fa-inbox"></i> No se encontraron registros de acceso.
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
    {{ $accesos->links() }}
</div>
@endsection

