<?php
/**
 * Script de prueba para verificar rutas de Laravel
 * Accede a: http://fmpafia.ddns.net:9191/documentos/test-routes.php
 */

echo "<h1>🔍 Diagnóstico de Rutas Laravel</h1>";

echo "<h2>1. Información del Servidor</h2>";
echo "<ul>";
echo "<li><strong>PHP Version:</strong> " . phpversion() . "</li>";
echo "<li><strong>Document Root:</strong> " . $_SERVER['DOCUMENT_ROOT'] . "</li>";
echo "<li><strong>Script Name:</strong> " . $_SERVER['SCRIPT_NAME'] . "</li>";
echo "<li><strong>Request URI:</strong> " . $_SERVER['REQUEST_URI'] . "</li>";
echo "<li><strong>Base Path:</strong> " . __DIR__ . "</li>";
echo "</ul>";

echo "<h2>2. Verificación de Archivos</h2>";
$files = [
    'index.php' => __DIR__ . '/index.php',
    '.htaccess' => __DIR__ . '/.htaccess',
    'bootstrap/app.php' => __DIR__ . '/../bootstrap/app.php',
    'routes/web.php' => __DIR__ . '/../routes/web.php',
];

foreach ($files as $name => $path) {
    $exists = file_exists($path);
    $icon = $exists ? '✅' : '❌';
    echo "<p>{$icon} <strong>{$name}:</strong> " . ($exists ? 'Existe' : 'NO EXISTE') . "</p>";
}

echo "<h2>3. Prueba de Bootstrap de Laravel</h2>";
try {
    require __DIR__ . '/../vendor/autoload.php';
    $app = require_once __DIR__ . '/../bootstrap/app.php';
    echo "<p>✅ Laravel se inicializó correctamente</p>";
    
    echo "<h3>Rutas Registradas:</h3>";
    try {
        $router = $app->make('router');
        $routes = $router->getRoutes();
        echo "<ul>";
        foreach ($routes as $route) {
            $uri = $route->uri();
            $methods = implode('|', $route->methods());
            if (strpos($uri, 'login') !== false || $uri === '/' || strpos($uri, 'admin') !== false || strpos($uri, 'vendedor') !== false) {
                echo "<li><strong>{$methods}</strong> /{$uri}</li>";
            }
        }
        echo "</ul>";
    } catch (Exception $e) {
        echo "<p>⚠️ No se pudieron obtener las rutas: " . $e->getMessage() . "</p>";
    }
    
    echo "<h3>Prueba de Ruta Directa:</h3>";
    try {
        $request = \Illuminate\Http\Request::create('/login', 'GET');
        $response = $app->handle($request);
        echo "<p>✅ La ruta /login responde correctamente</p>";
        echo "<p><strong>Status:</strong> " . $response->getStatusCode() . "</p>";
    } catch (Exception $e) {
        echo "<p>❌ Error al probar la ruta: " . $e->getMessage() . "</p>";
    }
    
} catch (Exception $e) {
    echo "<p>❌ <strong>Error:</strong> " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}

echo "<h2>4. Prueba de Acceso Directo</h2>";
echo "<p>Prueba estas URLs:</p>";
echo "<ul>";
echo "<li><a href='/documentos/'>/documentos/</a></li>";
echo "<li><a href='/documentos/login'>/documentos/login</a></li>";
echo "<li><a href='/documentos/vendedor/login'>/documentos/vendedor/login</a></li>";
echo "</ul>";

echo "<h2>5. Información de .htaccess</h2>";
$htaccess = file_get_contents(__DIR__ . '/.htaccess');
if (strpos($htaccess, 'RewriteBase /documentos/') !== false) {
    echo "<p>✅ RewriteBase /documentos/ está configurado</p>";
} else {
    echo "<p>❌ RewriteBase /documentos/ NO está configurado</p>";
}

echo "<hr>";
echo "<p><small>Elimina este archivo después de verificar por seguridad.</small></p>";

