<?php
/**
 * Script de prueba para verificar si .htaccess está funcionando
 * Visita: http://fmpafia.ddns.net:9191/documentos/test-htaccess.php
 */

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Test .htaccess</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 800px; margin: 50px auto; padding: 20px; }
        .ok { color: green; font-weight: bold; }
        .error { color: red; font-weight: bold; }
        pre { background: #f5f5f5; padding: 15px; border-radius: 5px; }
    </style>
</head>
<body>
    <h1>Test de .htaccess</h1>
    
    <h2>Información del Servidor:</h2>
    <ul>
        <li><strong>Document Root:</strong> <?php echo $_SERVER['DOCUMENT_ROOT']; ?></li>
        <li><strong>Script Name:</strong> <?php echo $_SERVER['SCRIPT_NAME']; ?></li>
        <li><strong>Request URI:</strong> <?php echo $_SERVER['REQUEST_URI']; ?></li>
        <li><strong>PHP Self:</strong> <?php echo $_SERVER['PHP_SELF']; ?></li>
    </ul>
    
    <h2>Verificación de .htaccess:</h2>
    <?php
    $htaccessPath = __DIR__ . '/.htaccess';
    if (file_exists($htaccessPath)) {
        echo '<p class="ok">✓ El archivo .htaccess existe</p>';
        $content = file_get_contents($htaccessPath);
        echo '<h3>Contenido del .htaccess:</h3>';
        echo '<pre>' . htmlspecialchars($content) . '</pre>';
    } else {
        echo '<p class="error">✗ El archivo .htaccess NO existe</p>';
    }
    ?>
    
    <h2>Prueba de Rutas:</h2>
    <p>Si puedes ver esta página, significa que PHP está funcionando.</p>
    <p>Ahora prueba estas URLs:</p>
    <ul>
        <li><a href="/documentos/index.php">/documentos/index.php</a> (debe funcionar)</li>
        <li><a href="/documentos/">/documentos/</a> (debe redirigir o mostrar login)</li>
        <li><a href="/documentos/login">/documentos/login</a> (debe mostrar login si .htaccess funciona)</li>
    </ul>
    
    <h2>Diagnóstico:</h2>
    <p>Si <code>/documentos/index.php</code> funciona pero <code>/documentos/login</code> da 404, el problema es que:</p>
    <ol>
        <li>Apache NO está leyendo el .htaccess, o</li>
        <li>mod_rewrite NO está habilitado, o</li>
        <li>El Alias de Apache NO está configurado correctamente</li>
    </ol>
</body>
</html>

