<?php
/**
 * Test directo - sin .htaccess
 * Visita: http://localhost/documentos/test-direct.php
 * O: http://fmpafia.ddns.net:9191/documentos/test-direct.php
 */
header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
<head>
    <title>Test Directo</title>
    <style>
        body { font-family: Arial; padding: 20px; }
        .ok { color: green; }
        .error { color: red; }
        pre { background: #f5f5f5; padding: 10px; }
    </style>
</head>
<body>
    <h1>✅ Test Directo - PHP Funciona</h1>
    
    <h2>Información del Servidor:</h2>
    <ul>
        <li><strong>Document Root:</strong> <?php echo $_SERVER['DOCUMENT_ROOT']; ?></li>
        <li><strong>Script Name:</strong> <?php echo $_SERVER['SCRIPT_NAME']; ?></li>
        <li><strong>Request URI:</strong> <?php echo $_SERVER['REQUEST_URI']; ?></li>
        <li><strong>PHP Self:</strong> <?php echo $_SERVER['PHP_SELF']; ?></li>
        <li><strong>Server Name:</strong> <?php echo $_SERVER['SERVER_NAME']; ?></li>
        <li><strong>Server Port:</strong> <?php echo $_SERVER['SERVER_PORT']; ?></li>
    </ul>
    
    <h2>Verificación de Archivos:</h2>
    <ul>
        <li><strong>index.php existe:</strong> 
            <?php echo file_exists(__DIR__ . '/index.php') ? '<span class="ok">✅ SÍ</span>' : '<span class="error">❌ NO</span>'; ?>
        </li>
        <li><strong>.htaccess existe:</strong> 
            <?php echo file_exists(__DIR__ . '/.htaccess') ? '<span class="ok">✅ SÍ</span>' : '<span class="error">❌ NO</span>'; ?>
        </li>
        <li><strong>Ruta actual:</strong> <code><?php echo __DIR__; ?></code></li>
    </ul>
    
    <h2>Prueba de Rutas:</h2>
    <p>Si puedes ver esta página, PHP está funcionando.</p>
    <p>Ahora prueba:</p>
    <ul>
        <li><a href="/documentos/index.php">/documentos/index.php</a></li>
        <li><a href="/documentos/login">/documentos/login</a></li>
    </ul>
    
    <h2>Diagnóstico:</h2>
    <p>Si <code>/documentos/index.php</code> funciona pero <code>/documentos/login</code> da 404:</p>
    <ul>
        <li>El problema es con el <code>.htaccess</code> o <code>mod_rewrite</code></li>
        <li>Verifica que <code>mod_rewrite</code> esté habilitado</li>
        <li>Verifica que <code>AllowOverride All</code> esté configurado</li>
    </ul>
</body>
</html>

