/**
 * Atajos de Teclado para el Sistema
 */

(function() {
    const shortcuts = {
        // Navegación
        'g d': () => window.location.href = '/admin/dashboard',
        'g c': () => window.location.href = '/admin/clientes',
        'g u': () => window.location.href = '/admin/usuarios',
        'g s': () => window.location.href = '/admin/solicitudes',
        'g n': () => window.location.href = '/admin/notificaciones',
        'g r': () => window.location.href = '/admin/reportes',
        'g a': () => window.location.href = '/admin/auditoria',
        'g o': () => window.location.href = '/admin/configuracion',
        
        // Acciones
        'n': (e) => {
            const newBtn = document.querySelector('a.btn-primary[href*="create"], a.btn-primary[href*="nuevo"]');
            if (newBtn && !e.target.matches('input, textarea, select')) {
                newBtn.click();
            }
        },
        
        // Búsqueda
        '/': (e) => {
            if (!e.target.matches('input, textarea, select')) {
                e.preventDefault();
                const searchInput = document.querySelector('input[name="buscar"], input[type="search"], #buscar');
                if (searchInput) {
                    searchInput.focus();
                    searchInput.select();
                }
            }
        },
        
        // Escape
        'Escape': () => {
            // Cerrar modales
            const modal = document.querySelector('.modal-overlay.active');
            if (modal) {
                modal.classList.remove('active');
            }
            
            // Cerrar menú móvil
            const nav = document.getElementById('headerNav');
            if (nav && nav.classList.contains('active')) {
                nav.classList.remove('active');
                const toggle = document.getElementById('menuToggle');
                if (toggle) {
                    const icon = toggle.querySelector('i');
                    icon.classList.remove('fa-times');
                    icon.classList.add('fa-bars');
                }
            }
            
            // Cerrar dropdown de notificaciones
            const notifMenu = document.getElementById('notificationsMenu');
            if (notifMenu && notifMenu.classList.contains('active')) {
                notifMenu.classList.remove('active');
            }
        },
    };

    let currentKeys = [];
    const maxSequenceLength = 2;
    let sequenceTimeout;

    document.addEventListener('keydown', function(e) {
        // Ignorar si está escribiendo en un input
        if (e.target.matches('input, textarea, select') && !e.ctrlKey && !e.metaKey) {
            // Permitir solo Escape y búsqueda
            if (e.key === 'Escape' || (e.key === '/' && !e.shiftKey)) {
                // Continuar
            } else {
                return;
            }
        }

        const key = e.key.toLowerCase();
        
        // Atajos simples (una tecla)
        if (shortcuts[e.key]) {
            shortcuts[e.key](e);
            return;
        }

        // Atajos de secuencia (g + letra)
        if (key === 'g' || (currentKeys.length > 0 && currentKeys[0] === 'g')) {
            currentKeys.push(key);
            
            clearTimeout(sequenceTimeout);
            sequenceTimeout = setTimeout(() => {
                currentKeys = [];
            }, 1000);

            if (currentKeys.length === 2) {
                const sequence = currentKeys.join(' ');
                if (shortcuts[sequence]) {
                    e.preventDefault();
                    shortcuts[sequence]();
                    currentKeys = [];
                } else if (currentKeys[0] === 'g' && currentKeys[1] !== 'g') {
                    // Secuencia inválida, resetear
                    currentKeys = [];
                }
            }

            if (currentKeys.length > maxSequenceLength) {
                currentKeys = [];
            }
        } else {
            currentKeys = [];
        }
    });

    // Mostrar ayuda de atajos
    document.addEventListener('keydown', function(e) {
        // Ctrl + ? o Ctrl + Shift + /
        if ((e.ctrlKey || e.metaKey) && (e.key === '?' || (e.shiftKey && e.key === '/'))) {
            e.preventDefault();
            mostrarAyudaAtajos();
        }
    });

    function mostrarAyudaAtajos() {
        const ayuda = `
            <div class="keyboard-shortcuts-help">
                <h3><i class="fas fa-keyboard"></i> Atajos de Teclado</h3>
                <div class="shortcuts-list">
                    <div class="shortcut-group">
                        <h4>Navegación (g + letra)</h4>
                        <div class="shortcut-item">
                            <kbd>g</kbd> + <kbd>d</kbd> <span>Dashboard</span>
                        </div>
                        <div class="shortcut-item">
                            <kbd>g</kbd> + <kbd>c</kbd> <span>Clientes</span>
                        </div>
                        <div class="shortcut-item">
                            <kbd>g</kbd> + <kbd>u</kbd> <span>Usuarios</span>
                        </div>
                        <div class="shortcut-item">
                            <kbd>g</kbd> + <kbd>s</kbd> <span>Solicitudes</span>
                        </div>
                        <div class="shortcut-item">
                            <kbd>g</kbd> + <kbd>r</kbd> <span>Reportes</span>
                        </div>
                        <div class="shortcut-item">
                            <kbd>g</kbd> + <kbd>a</kbd> <span>Auditoría</span>
                        </div>
                    </div>
                    <div class="shortcut-group">
                        <h4>Acciones</h4>
                        <div class="shortcut-item">
                            <kbd>/</kbd> <span>Buscar</span>
                        </div>
                        <div class="shortcut-item">
                            <kbd>n</kbd> <span>Nuevo (si hay botón)</span>
                        </div>
                        <div class="shortcut-item">
                            <kbd>Esc</kbd> <span>Cerrar modales/menús</span>
                        </div>
                    </div>
                    <div class="shortcut-group">
                        <h4>Ayuda</h4>
                        <div class="shortcut-item">
                            <kbd>Ctrl</kbd> + <kbd>?</kbd> <span>Mostrar esta ayuda</span>
                        </div>
                    </div>
                </div>
            </div>
        `;

        modalManager.alert({
            title: 'Atajos de Teclado',
            message: ayuda,
            type: 'info',
            buttonText: 'Cerrar'
        });
    }

    // Agregar indicador visual cuando se presiona 'g'
    document.addEventListener('keydown', function(e) {
        if (e.key.toLowerCase() === 'g' && !e.target.matches('input, textarea, select')) {
            mostrarIndicador('g');
        }
    });

    function mostrarIndicador(key) {
        let indicator = document.getElementById('keyboard-indicator');
        if (!indicator) {
            indicator = document.createElement('div');
            indicator.id = 'keyboard-indicator';
            indicator.style.cssText = `
                position: fixed;
                top: 20px;
                right: 20px;
                background: rgba(0,0,0,0.8);
                color: white;
                padding: 0.5rem 1rem;
                border-radius: 4px;
                z-index: 10000;
                font-family: monospace;
                font-size: 1.2rem;
                display: none;
            `;
            document.body.appendChild(indicator);
        }
        indicator.textContent = key;
        indicator.style.display = 'block';
        setTimeout(() => {
            indicator.style.display = 'none';
        }, 500);
    }
})();

