# 📋 Archivos que Debes Copiar Manualmente

## ⚠️ IMPORTANTE: Estos archivos deben copiarse desde tu proyecto actual

### 1. Assets CSS/JS (Obligatorios)

**Desde:** `assets/`  
**Hacia:** `public/assets/`

- `assets/css/style.css` → `public/assets/css/style.css`
- `assets/css/all.min.css` → `public/assets/css/all.min.css`
- `assets/js/mani.js` → `public/assets/js/mani.js`

**Comando:**
```bash
xcopy /E /I assets public\assets
```

### 2. Assets Vendedor (Obligatorios)

**Desde:** `vendedor/assets/`  
**Hacia:** `public/vendedor/assets/`

- `vendedor/assets/css/style.css` → `public/vendedor/assets/css/style.css`
- `vendedor/assets/js/service-worker-register.js` → `public/vendedor/assets/js/service-worker-register.js`
- `vendedor/assets/js/pwa-manager.js` → `public/vendedor/assets/js/pwa-manager.js`
- `vendedor/assets/js/offline-document-manager.js` → `public/vendedor/assets/js/offline-document-manager.js`
- `vendedor/assets/js/push-notifications.js` → `public/vendedor/assets/js/push-notifications.js`

**Comando:**
```bash
xcopy /E /I vendedor\assets public\vendedor\assets
```

### 3. Iconos PWA (Obligatorios)

**Desde:** `vendedor/assets/icons/`  
**Hacia:** `public/vendedor/assets/icons/`

**Mínimo requerido:**
- `icon-192x192.png` ⚠️ **OBLIGATORIO**
- `icon-512x512.png` ⚠️ **OBLIGATORIO**

**Opcionales pero recomendados:**
- `icon-16x16.png`
- `icon-32x32.png`
- `icon-72x72.png`
- `icon-96x96.png`
- `icon-128x128.png`
- `icon-144x144.png`
- `icon-152x152.png`
- `icon-384x384.png`

**Comando:**
```bash
mkdir public\vendedor\assets\icons
xcopy /E /I vendedor\assets\icons public\vendedor\assets\icons
```

### 4. Archivos de Clientes

**Desde:** `archivos/`  
**Hacia:** `storage/app/public/archivos/`

**Comando:**
```bash
xcopy /E /I archivos storage\app\public\archivos
```

## 📝 Checklist de Archivos

Antes de iniciar la aplicación, verifica que existan:

- [ ] `public/assets/css/style.css`
- [ ] `public/assets/css/all.min.css`
- [ ] `public/assets/js/mani.js`
- [ ] `public/vendedor/assets/css/style.css`
- [ ] `public/vendedor/assets/js/service-worker-register.js`
- [ ] `public/vendedor/assets/js/pwa-manager.js`
- [ ] `public/vendedor/assets/js/offline-document-manager.js`
- [ ] `public/vendedor/assets/js/push-notifications.js`
- [ ] `public/vendedor/assets/icons/icon-192x192.png` ⚠️
- [ ] `public/vendedor/assets/icons/icon-512x512.png` ⚠️
- [ ] `storage/app/public/archivos/` (directorio creado)

## 🚨 Sin estos archivos la aplicación NO funcionará correctamente
