<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Rol;

class RolSeeder extends Seeder
{
    public function run(): void
    {
        $roles = [
            [
                'nombre_rol' => 'Administrador',
                'descripcion' => 'Acceso completo al sistema',
                'permisos' => [
                    'clientes' => ['create', 'read', 'update', 'delete'],
                    'usuarios' => ['create', 'read', 'update', 'delete'],
                    'documentos' => ['create', 'read', 'update', 'delete'],
                    'solicitudes' => ['read', 'approve', 'reject'],
                    'reportes' => ['read', 'export'],
                ],
            ],
            [
                'nombre_rol' => 'Vendedor',
                'descripcion' => 'Acceso al portal de vendedores',
                'permisos' => [
                    'clientes' => ['read'],
                    'documentos' => ['create', 'read'],
                    'solicitudes' => ['create'],
                ],
            ],
        ];

        foreach ($roles as $rol) {
            Rol::updateOrCreate(
                ['nombre_rol' => $rol['nombre_rol']],
                $rol
            );
        }
    }
}

