<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Configuracion;

class ConfiguracionSeeder extends Seeder
{
    public function run(): void
    {
        $configuraciones = [
            // Documentos
            [
                'clave' => 'dias_alerta_vencimiento',
                'valor' => '180',
                'tipo' => 'number',
                'descripcion' => 'Días de anticipación para alerta de vencimiento (por defecto: 6 meses)',
                'categoria' => 'documentos',
            ],
            [
                'clave' => 'tamaño_maximo_archivo_mb',
                'valor' => '10',
                'tipo' => 'number',
                'descripcion' => 'Tamaño máximo de archivo en MB',
                'categoria' => 'documentos',
            ],
            [
                'clave' => 'tipos_archivo_permitidos',
                'valor' => 'pdf,jpg,jpeg,png',
                'tipo' => 'text',
                'descripcion' => 'Tipos de archivo permitidos (separados por coma)',
                'categoria' => 'documentos',
            ],
            // Sistema
            [
                'clave' => 'items_por_pagina',
                'valor' => '20',
                'tipo' => 'number',
                'descripcion' => 'Número de items por página por defecto',
                'categoria' => 'sistema',
            ],
            [
                'clave' => 'actualizacion_notificaciones_segundos',
                'valor' => '30',
                'tipo' => 'number',
                'descripcion' => 'Intervalo de actualización de notificaciones en segundos',
                'categoria' => 'sistema',
            ],
            // Apariencia
            [
                'clave' => 'color_primario',
                'valor' => '#0d6efd',
                'tipo' => 'text',
                'descripcion' => 'Color primario del sistema',
                'categoria' => 'apariencia',
            ],
            [
                'clave' => 'color_secundario',
                'valor' => '#6c757d',
                'tipo' => 'text',
                'descripcion' => 'Color secundario del sistema',
                'categoria' => 'apariencia',
            ],
        ];

        foreach ($configuraciones as $config) {
            Configuracion::updateOrCreate(
                ['clave' => $config['clave']],
                $config
            );
        }
    }
}

