<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('notificaciones', function (Blueprint $table) {
            $table->id();
            $table->foreignId('destinatario_id')->constrained('users')->onDelete('cascade');
            $table->string('titulo');
            $table->text('mensaje');
            $table->string('tipo', 50)->default('info');
            $table->boolean('leida')->default(false);
            $table->timestamps();
            
            $table->index('destinatario_id');
            $table->index('leida');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('notificaciones');
    }
};

