<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('solicitudes_edicion_cliente', function (Blueprint $table) {
            $table->id();
            $table->foreignId('cliente_id')->constrained('clientes')->onDelete('cascade');
            $table->foreignId('vendedor_id')->constrained('users')->onDelete('cascade');
            $table->json('cambios');
            $table->enum('estatus', ['Pendiente', 'Aprobada', 'Rechazada'])->default('Pendiente');
            $table->timestamp('fecha_solicitud')->useCurrent();
            $table->foreignId('revisado_por_id')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('fecha_revision')->nullable();
            $table->text('observaciones')->nullable();
            $table->timestamps();
            
            $table->index('cliente_id');
            $table->index('vendedor_id');
            $table->index('estatus');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('solicitudes_edicion_cliente');
    }
};

