<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('solicitudes_creacion_cliente', function (Blueprint $table) {
            $table->id();
            $table->foreignId('vendedor_id')->constrained('users')->onDelete('cascade');
            $table->string('nombre_empresa');
            $table->string('rif', 50);
            $table->text('direccion_fiscal')->nullable();
            $table->string('zona', 100)->nullable();
            $table->text('notas')->nullable();
            $table->enum('estatus', ['Pendiente', 'Aprobada', 'Rechazada'])->default('Pendiente');
            $table->timestamp('fecha_solicitud')->useCurrent();
            $table->foreignId('revisado_por_id')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('fecha_revision')->nullable();
            $table->text('observaciones')->nullable();
            $table->timestamps();
            
            $table->index('vendedor_id');
            $table->index('estatus');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('solicitudes_creacion_cliente');
    }
};

