<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('documentos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('cliente_id')->constrained('clientes')->onDelete('cascade');
            $table->foreignId('tipo_documento_id')->constrained('tipos_documento')->onDelete('restrict');
            $table->string('nombre_archivo');
            $table->string('ruta_archivo', 500);
            $table->date('fecha_vencimiento')->nullable();
            $table->text('observaciones')->nullable();
            $table->foreignId('creado_por_id')->constrained('users')->onDelete('restrict');
            $table->timestamps();
            
            $table->index('cliente_id');
            $table->index('tipo_documento_id');
            $table->index('fecha_vencimiento');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('documentos');
    }
};

