<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('clientes', function (Blueprint $table) {
            $table->id();
            $table->string('nombre_empresa');
            $table->string('rif', 50)->unique();
            $table->text('direccion_fiscal')->nullable();
            $table->string('zona', 100)->nullable();
            $table->foreignId('vendedor_id')->nullable()->constrained('users')->onDelete('set null');
            $table->text('notas')->nullable();
            $table->foreignId('creado_por_id')->constrained('users')->onDelete('restrict');
            $table->foreignId('modificado_por_id')->constrained('users')->onDelete('restrict');
            $table->timestamps();
            
            $table->index('rif');
            $table->index('vendedor_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('clientes');
    }
};

