@echo off
echo ========================================
echo CORREGIR ALIAS APACHE PARA /documentos/
echo ========================================
echo.
echo PROBLEMA DETECTADO:
echo El Alias de Apache esta apuntando al directorio raiz
echo en lugar de apuntar a public/
echo.
echo SOLUCION:
echo El Alias debe apuntar a: C:/laragon/www/DOCUMENTOS/public
echo.
echo ========================================
echo.

REM Buscar httpd.conf en Laragon
set LARAGON_PATH=C:\laragon
set HTTPD_CONF=

echo Buscando httpd.conf en Laragon...

REM Buscar en la ruta tipica de Laragon
for /d %%i in ("%LARAGON_PATH%\bin\apache\apache-*") do (
    if exist "%%i\conf\httpd.conf" (
        set HTTPD_CONF=%%i\conf\httpd.conf
        goto :found
    )
)

REM Buscar en etc/apache2
if exist "%LARAGON_PATH%\etc\apache2\httpd.conf" (
    set HTTPD_CONF=%LARAGON_PATH%\etc\apache2\httpd.conf
    goto :found
)

echo ERROR: No se encontro httpd.conf en Laragon
echo.
echo Busca manualmente el archivo httpd.conf en:
echo - C:\laragon\bin\apache\apache-{version}\conf\httpd.conf
echo - C:\laragon\etc\apache2\httpd.conf
echo.
pause
exit /b 1

:found
echo.
echo Archivo encontrado: %HTTPD_CONF%
echo.
echo ========================================
echo INSTRUCCIONES:
echo ========================================
echo.
echo 1. Busca en el archivo una linea que diga:
echo    Alias /documentos "C:/laragon/www/DOCUMENTOS"
echo.
echo 2. CAMBIALA por:
echo    Alias /documentos "C:/laragon/www/DOCUMENTOS/public"
echo.
echo    IMPORTANTE: Debe terminar en /public
echo.
echo 3. Busca tambien el Directory y asegurate de que diga:
echo    ^<Directory "C:/laragon/www/DOCUMENTOS/public"^>
echo.
echo    NO debe ser solo "C:/laragon/www/DOCUMENTOS"
echo.
echo 4. Guarda el archivo
echo.
echo 5. REINICIA Apache en Laragon
echo.
echo ========================================
echo.
pause

REM Intentar abrir con notepad
start notepad "%HTTPD_CONF%"

echo.
echo El archivo se ha abierto en el editor.
echo.
echo Despues de hacer los cambios:
echo 1. Guarda el archivo
echo 2. REINICIA Apache en Laragon
echo 3. Prueba: http://fmpafia.ddns.net:9191/documentos/
echo.
pause

