@echo off
echo ========================================
echo Configurar Apache en Laragon para /documentos/
echo ========================================
echo.

REM Buscar httpd.conf en Laragon
set LARAGON_PATH=C:\laragon
set HTTPD_CONF=

echo Buscando httpd.conf en Laragon...

REM Buscar en la ruta típica de Laragon
if exist "%LARAGON_PATH%\bin\apache\apache-2.4\conf\httpd.conf" (
    set HTTPD_CONF=%LARAGON_PATH%\bin\apache\apache-2.4\conf\httpd.conf
    goto :found
)

REM Buscar cualquier versión de Apache
for /d %%i in ("%LARAGON_PATH%\bin\apache\apache-*") do (
    if exist "%%i\conf\httpd.conf" (
        set HTTPD_CONF=%%i\conf\httpd.conf
        goto :found
    )
)

REM Buscar en etc/apache2
if exist "%LARAGON_PATH%\etc\apache2\httpd.conf" (
    set HTTPD_CONF=%LARAGON_PATH%\etc\apache2\httpd.conf
    goto :found
)

echo ERROR: No se encontro httpd.conf en Laragon
echo.
echo Busca manualmente el archivo httpd.conf en:
echo - C:\laragon\bin\apache\apache-{version}\conf\httpd.conf
echo - C:\laragon\etc\apache2\httpd.conf
echo.
pause
exit /b 1

:found
echo.
echo Archivo encontrado: %HTTPD_CONF%
echo.
echo Abriendo el archivo en el editor...
echo.
echo IMPORTANTE: Agrega esto al FINAL del archivo:
echo.
echo ========================================
echo Listen 9191
echo.
echo Alias /documentos "C:/laragon/www/DOCUMENTOS/public"
echo.
echo ^<Directory "C:/laragon/www/DOCUMENTOS/public"^>
echo     Options Indexes FollowSymLinks
echo     AllowOverride All
echo     Require all granted
echo     RewriteEngine On
echo ^</Directory^>
echo ========================================
echo.
echo Despues de agregar la configuracion, REINICIA Apache en Laragon.
echo.
pause

REM Intentar abrir con notepad
start notepad "%HTTPD_CONF%"

echo.
echo Presiona cualquier tecla cuando hayas terminado de editar...
pause >nul

echo.
echo Recuerda REINICIAR Apache en Laragon despues de guardar los cambios.
echo.
pause

