<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        $middleware->alias([
            'role' => \App\Http\Middleware\CheckRole::class,
            'vendedor' => \App\Http\Middleware\CheckVendedor::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        // Manejar errores relacionados con favicon.png.base64
        $exceptions->render(function (\ErrorException $e, $request) {
            if (strpos($e->getMessage(), 'favicon.png.base64') !== false) {
                return response()->view('errors.500', [
                    'exception' => $e
                ], 500);
            }
        });
    })->create();
