<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Configuracion extends Model
{
    use HasFactory;

    protected $table = 'configuraciones';

    protected $fillable = [
        'clave',
        'valor',
        'tipo',
        'descripcion',
        'categoria',
    ];

    /**
     * Obtener el valor de una configuración
     */
    public static function obtener($clave, $default = null)
    {
        $config = self::where('clave', $clave)->first();
        
        if (!$config) {
            return $default;
        }

        return match($config->tipo) {
            'boolean' => filter_var($config->valor, FILTER_VALIDATE_BOOLEAN),
            'number' => is_numeric($config->valor) ? (int)$config->valor : $default,
            'json' => json_decode($config->valor, true) ?? $default,
            default => $config->valor ?? $default,
        };
    }

    /**
     * Establecer el valor de una configuración
     */
    public static function establecer($clave, $valor, $tipo = 'text', $descripcion = null, $categoria = 'general')
    {
        return self::updateOrCreate(
            ['clave' => $clave],
            [
                'valor' => is_array($valor) ? json_encode($valor) : $valor,
                'tipo' => $tipo,
                'descripcion' => $descripcion,
                'categoria' => $categoria,
            ]
        );
    }
}

