<?php

namespace App\Http\Controllers\Vendedor;

use App\Http\Controllers\Controller;
use App\Models\Cliente;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ClienteController extends Controller
{
    public function index(Request $request)
    {
        $vendedorId = Auth::id();
        $view = $request->get('view', 'todos');

        $query = Cliente::deVendedor($vendedorId)
            ->with(['documentos.tipoDocumento']);

        if ($view === 'proximos') {
            // Filtrar solo clientes con documentos próximos a vencer
            $query->whereHas('documentos', function($q) {
                $q->proximosAVencer(6);
            });
        }

        $clientes = $query->orderBy('nombre_empresa')->get();

        return view('vendedor.clientes.index', [
            'clientes' => $clientes,
            'view' => $view,
        ]);
    }

    public function show(Cliente $cliente)
    {
        // Verificar que el cliente pertenece al vendedor
        if ($cliente->vendedor_id !== Auth::id()) {
            abort(403, 'No tienes acceso a este cliente.');
        }

        $cliente->load(['documentos.tipoDocumento', 'vendedor', 'historialCambios.usuario']);
        $estatus = $cliente->calcularEstatus();
        $tiposDocumento = \App\Models\TipoDocumento::activos()->get();

        return view('vendedor.clientes.show', [
            'cliente' => $cliente,
            'estatus' => $estatus,
            'tiposDocumento' => $tiposDocumento,
        ]);
    }
}

